/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.gui.GuiClock;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.items.ItemLock;
import jds.bibliocraft.tileentities.TileEntityClock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockClock
extends BlockContainer {
    public int angle;
    public String customTexture = "none";

    public BlockClock() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(BlockLoader.biblioTab);
        this.func_149711_c(2.5f);
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityClock) {
            ItemStack playerhand;
            TileEntityClock clock = (TileEntityClock)tile;
            String playername = player.getDisplayName();
            boolean islocked = false;
            String lockeename = "";
            if (clock != null) {
                islocked = clock.isLocked();
                lockeename = clock.getLockee();
            }
            if ((playerhand = player.func_70694_bm()) != null && !world.field_72995_K && playerhand.func_77973_b() instanceof ItemLock && clock != null) {
                if (islocked) {
                    if (playername.contains(lockeename)) {
                        clock.setLocked(false, true);
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.unlocked")));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
                    }
                } else {
                    clock.setLockee(playername, true);
                    clock.setLocked(true, true);
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.locked")));
                }
                return true;
            }
            if (!islocked || playername.contains(lockeename)) {
                if (playerhand != null && playerhand.func_77973_b() instanceof ItemDrill) {
                    return false;
                }
                if (world.field_72995_K && player.func_70093_af()) {
                    if (clock.getClockType() == 2) {
                        TileEntity upperTile = world.func_147438_o(i, j + 1, k);
                        if (upperTile != null && upperTile instanceof TileEntityClock) {
                            this.openGUI((TileEntityClock)upperTile, player);
                        }
                    } else {
                        this.openGUI((TileEntityClock)tile, player);
                    }
                }
                return true;
            }
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void openGUI(TileEntityClock clock, EntityPlayer player) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiClock(clock, player));
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public int func_149709_b(IBlockAccess blocka, int i, int j, int k, int face) {
        TileEntity tile = blocka.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntityClock clock = (TileEntityClock)tile;
            if (clock.redstoneActive) {
                return 15;
            }
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess blocka, int i, int j, int k, int face) {
        return this.func_149709_b(blocka, i, j, k, face);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 6; ++x) {
            subItems.add(new ItemStack(par1, 1, x));
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity te = blockAccess.func_147438_o(i, j, k);
        if (te != null && te instanceof TileEntityClock) {
            TileEntityClock tile = (TileEntityClock)te;
            int angleGet = tile.getAngle();
            float shiftAmount = 0.0f;
            if (tile.getShift()) {
                shiftAmount = 0.675f;
            }
            switch (angleGet) {
                case 0: {
                    this.func_149676_a(0.73f - shiftAmount, 0.0f, 0.3f, 1.0f - shiftAmount, 1.0f, 0.7f);
                    break;
                }
                case 1: {
                    this.func_149676_a(0.3f, 0.0f, 0.73f - shiftAmount, 0.7f, 1.0f, 1.0f - shiftAmount);
                    break;
                }
                case 2: {
                    this.func_149676_a(0.0f + shiftAmount, 0.0f, 0.3f, 0.27f + shiftAmount, 1.0f, 0.7f);
                    break;
                }
                case 3: {
                    this.func_149676_a(0.3f, 0.0f, 0.0f + shiftAmount, 0.7f, 1.0f, 0.27f + shiftAmount);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.clockRenderID;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        this.angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++this.angle;
        this.angle %= 4;
        TileEntityClock tile = (TileEntityClock)world.func_147438_o(i, j, k);
        tile.setAngle(this.angle);
        NBTTagCompound tags = itemStack.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            tile.setCustomTex(tags.func_74779_i("renderTexture"));
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntityClock furniture = (TileEntityClock)tile;
            this.customTexture = furniture.getCustomTexString();
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ItemStack newStack = new ItemStack(item, 1, this.func_149692_a(metadata));
            if (metadata == 6 && !this.customTexture.contentEquals("none") && !this.customTexture.contentEquals("")) {
                NBTTagCompound tags = new NBTTagCompound();
                tags.func_74778_a("renderTexture", this.customTexture);
                newStack.func_77982_d(tags);
            }
            ret.add(newStack);
        }
        return ret;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntity topTile;
            TileEntityClock clock = (TileEntityClock)tile;
            if (clock.getClockType() == 1) {
                TileEntity bottomTile = world.func_147438_o(i, j - 1, k);
                if (bottomTile != null && bottomTile instanceof TileEntityClock) {
                    TileEntityClock bottomClock = (TileEntityClock)bottomTile;
                    bottomClock.setClockType(0);
                }
            } else if (clock.getClockType() == 2 && (topTile = world.func_147438_o(i, j + 1, k)) != null && topTile instanceof TileEntityClock) {
                TileEntityClock topClock = (TileEntityClock)topTile;
                topClock.setClockType(0);
            }
        }
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return new TileEntityClock();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntityClock te = (TileEntityClock)tile;
            int angle = te.getAngle();
            switch (axis) {
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        String customTexture;
        TileEntityClock tile;
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        BlockClock block = item instanceof ItemBlock && !this.func_149648_K() ? Block.func_149634_a((Item)item) : this;
        ItemStack stack = new ItemStack(item, 1, block.func_149643_k(world, x, y, z));
        TileEntity wtile = world.func_147438_o(x, y, z);
        if (!(wtile == null || !(wtile instanceof TileEntityClock) || (tile = (TileEntityClock)wtile).func_145832_p() != 6 || (customTexture = tile.getCustomTexString()).equals("none") && customTexture.equals(""))) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74778_a("renderTexture", customTexture);
            stack.func_77982_d(tags);
        }
        return stack;
    }
}

